function [derivs] = bfor_endogenous_ms_solver_derivatives_analytic(f, Pmat, vars)
% 
% computes the analytic derivatives of the equilibrium conditions f and 
%   transition matrix Pmat with respect to the variables of the system
%   evaluated at steady state
%   
% Updated 2020/12
% Benigno, Foerster, Otrok, and Rebucci
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % 
% 
% INPUTS
%  f        = (n x 1) vector of symbols with the equilibrium equations
%  Pmat     = (ns x ns) matrix of symbols with the transition matrix
%  vars     = structure with elements that are variables of the system:
%       yvarsp, yvars, yvarss: non-predetermined variables
%       xvars, xvarslag, xvarss: pre-determined variables
%       epsp, eps: shocks
%       tvarsp, tvars: switching parameters
% 
% 
% OUTPUTS
%  derivs   = structure with elements of the first and second derivatives
%               of f with respect to vars, and first derivatives of Pmat
%               with respect to vars; both evaluated at steady state    
% 
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % 


% -- Dimensions -- %
ns = length(Pmat);
ny = length(vars.yvars);
nx = length(vars.xvars);
ne = length(vars.eps);
nt = length(vars.tvars);
n  = length(f);

varlist     = [vars.yvarsp; vars.yvars;  vars.xvars;  vars.xlag;   vars.epsp;   vars.eps;    vars.t1vars;  vars.t1varsp];
varlistss   = [vars.yvarss; vars.yvarss; vars.xvarss; vars.xvarss; zeros(ne,1); zeros(ne,1); vars.t1varss; vars.t1varss];

% -- First Order -- %
derivs.dfyp         = subs(jacobian(f,vars.yvarsp), varlist, varlistss);
derivs.dfy          = subs(jacobian(f,vars.yvars),  varlist, varlistss);
derivs.dfx          = subs(jacobian(f,vars.xvars),  varlist, varlistss);
derivs.dfxlag       = subs(jacobian(f,vars.xlag),   varlist, varlistss);
derivs.dfep         = subs(jacobian(f,vars.epsp),   varlist, varlistss);
derivs.dfe          = subs(jacobian(f,vars.eps),    varlist, varlistss);
derivs.dftp         = subs(jacobian(f,vars.tvarsp), varlist, varlistss);
derivs.dft          = subs(jacobian(f,vars.tvars),	varlist, varlistss);

% -- Second Order -- %
derivs.dfypyp       = subs(reshape(jacobian(reshape(jacobian(f,vars.yvarsp), [],1),vars.yvarsp),n,ny,ny), varlist, varlistss);
derivs.dfypy        = subs(reshape(jacobian(reshape(jacobian(f,vars.yvarsp), [],1),vars.yvars) ,n,ny,ny), varlist, varlistss);
derivs.dfypx        = subs(reshape(jacobian(reshape(jacobian(f,vars.yvarsp), [],1),vars.xvars) ,n,ny,nx), varlist, varlistss);
derivs.dfypxlag     = subs(reshape(jacobian(reshape(jacobian(f,vars.yvarsp), [],1),vars.xlag)  ,n,ny,nx), varlist, varlistss);
derivs.dfypep       = subs(reshape(jacobian(reshape(jacobian(f,vars.yvarsp), [],1),vars.epsp)  ,n,ny,ne), varlist, varlistss);
derivs.dfype        = subs(reshape(jacobian(reshape(jacobian(f,vars.yvarsp), [],1),vars.eps)   ,n,ny,ne), varlist, varlistss);
derivs.dfyptp       = subs(reshape(jacobian(reshape(jacobian(f,vars.yvarsp), [],1),vars.tvarsp),n,ny,nt), varlist, varlistss);
derivs.dfypt        = subs(reshape(jacobian(reshape(jacobian(f,vars.yvarsp), [],1),vars.tvars) ,n,ny,nt), varlist, varlistss);
derivs.dfyy         = subs(reshape(jacobian(reshape(jacobian(f,vars.yvars),  [],1),vars.yvars) ,n,ny,ny), varlist, varlistss);
derivs.dfyx         = subs(reshape(jacobian(reshape(jacobian(f,vars.yvars),  [],1),vars.xvars) ,n,ny,nx), varlist, varlistss);
derivs.dfyxlag      = subs(reshape(jacobian(reshape(jacobian(f,vars.yvars),  [],1),vars.xlag)  ,n,ny,nx), varlist, varlistss);
derivs.dfye         = subs(reshape(jacobian(reshape(jacobian(f,vars.yvars),  [],1),vars.eps)   ,n,ny,ne), varlist, varlistss);
derivs.dfytp        = subs(reshape(jacobian(reshape(jacobian(f,vars.yvars),  [],1),vars.tvarsp),n,ny,nt), varlist, varlistss);
derivs.dfyt         = subs(reshape(jacobian(reshape(jacobian(f,vars.yvars),  [],1),vars.tvars) ,n,ny,nt), varlist, varlistss);
derivs.dfxx         = subs(reshape(jacobian(reshape(jacobian(f,vars.xvars),  [],1),vars.xvars) ,n,nx,nx), varlist, varlistss);
derivs.dfxxlag      = subs(reshape(jacobian(reshape(jacobian(f,vars.xvars),  [],1),vars.xlag)  ,n,nx,nx), varlist, varlistss);
derivs.dfxe         = subs(reshape(jacobian(reshape(jacobian(f,vars.xvars),  [],1),vars.eps)   ,n,nx,ne), varlist, varlistss);
derivs.dfxtp        = subs(reshape(jacobian(reshape(jacobian(f,vars.xvars),  [],1),vars.tvarsp),n,nx,nt), varlist, varlistss);
derivs.dfxt         = subs(reshape(jacobian(reshape(jacobian(f,vars.xvars),  [],1),vars.tvars) ,n,nx,nt), varlist, varlistss);
derivs.dfxlagxlag   = subs(reshape(jacobian(reshape(jacobian(f,vars.xlag),   [],1),vars.xlag)  ,n,nx,nx), varlist, varlistss);
derivs.dfxlage      = subs(reshape(jacobian(reshape(jacobian(f,vars.xlag),   [],1),vars.eps)   ,n,nx,ne), varlist, varlistss);
derivs.dfxlagtp     = subs(reshape(jacobian(reshape(jacobian(f,vars.xlag),   [],1),vars.tvarsp),n,nx,nt), varlist, varlistss);
derivs.dfxlagt      = subs(reshape(jacobian(reshape(jacobian(f,vars.xlag),   [],1),vars.tvars) ,n,nx,nt), varlist, varlistss);
derivs.dfepep       = subs(reshape(jacobian(reshape(jacobian(f,vars.epsp),   [],1),vars.epsp)  ,n,ne,ne), varlist, varlistss);
derivs.dfee         = subs(reshape(jacobian(reshape(jacobian(f,vars.eps),    [],1),vars.eps)   ,n,ne,ne), varlist, varlistss);
derivs.dfetp        = subs(reshape(jacobian(reshape(jacobian(f,vars.eps),    [],1),vars.tvarsp),n,ne,nt), varlist, varlistss);
derivs.dfet         = subs(reshape(jacobian(reshape(jacobian(f,vars.eps),    [],1),vars.tvars) ,n,ne,nt), varlist, varlistss);
derivs.dftptp       = subs(reshape(jacobian(reshape(jacobian(f,vars.tvarsp), [],1),vars.tvarsp),n,nt,nt), varlist, varlistss);
derivs.dftpt        = subs(reshape(jacobian(reshape(jacobian(f,vars.tvarsp), [],1),vars.tvars) ,n,nt,nt), varlist, varlistss);
derivs.dftt         = subs(reshape(jacobian(reshape(jacobian(f,vars.tvars),  [],1),vars.tvars) ,n,nt,nt), varlist, varlistss);

% -- Transition Matrix -- %
derivs.dPy          = reshape(jacobian(reshape(Pmat,[],1),vars.yvars),ns,ns,ny);